'use strict';
angular.module('main.config', [])
    .constant('GFECLIENT_CONFIG', {
        "userAgent": "NVIDIAGFEClient",
        "windowName": "gfeclient",
        "mode": "prod",
        "jarvis": {
            "server": "https://accounts.nvgs.nvidia.com",
            "version": "1",
            "deviceId": "gfeclient",
            "clientId": "135333107684344109",
            "commonClientId": "102009640608333825",
            "cevoClientId": "165235150188183768",
            "clientDescription": "GFE {VERSION}",
            "redirectUrl": "https://rds-assets.nvidia.com/main/redirect/gfe-redirect.html#",
            "redirectUrlJarvisOauth": "https://rds-assets.nvidia.com/main/redirect/gfe-jarvis-oauth-redirect.html#",
            "defaultTimeout": 10000,
            "defaultTimeBetweenRetries": 500,
            "clientCapabilities": ["OAuthPortal"]
        },
        "gfwsl": {
            "server": "https://gfwsl.geforce.com/",
            "defaultTimeout": 30000,
            "postMethodTimeout": 60000
        },
        "gfservices": {
            "server": "https://services.gfe.nvidia.com/GFE/",
            "version": "v1.0"
        },
        "imageFormatService": {
            "server": "https://img.nvidiagrid.net/"
        },
        "jsEvents": {
            "server": "https://events.gfe.nvidia.com",
            "version": "v1.0",
            "schemaVersion": "4.0",
            "defaultRetries": 2,
            "defaultTimeBetweenRetries": 1000,
            "defaultTimeout": 30000,
            "msBetweenSendRequest": 5000,
            "maxEventsPerRequest": 128
        },
        "cms": {
            "server": "https://static.nvidiagrid.net/",
            "defaultRetries": 2
        },
        "nodeService": {
            "reconnection": true,
            "reconnectionDelay": 1000,
            "reconnectionDelayMax": 1000,
            "reconnectionAttempts": 20
        },
        "rds": {
            "clientId": "b7e85bb1-afe6-4867-b11f-a32a58b7f797",
            "portalRealm": "831c3b05-4aee-4060-998f-e67cc375c35f"
        },
        "anselFeature": true,
        "anselFeatureExperimental": true,
        "parllayConfig": {
            "env": "pro",
            "fhtToken": "AqJLydSIPI"
        },
        "survey": {
            "server": "https://api.gfe.nvidia.com/Survey/surveyengine/",
            "clientType": "gfe"
        },
        "cevo": {
            "server": "https://api.commune.ly/"
        },
        "aem": {
            "server": "https://www.nvidia.com/"
        },
        "feedback": {
            "server": "https://api.gfe.nvidia.com/Survey/feedbackengine/",
            "surveyId": "4b57d5dc-923d-4287-9b71-244eee8e30de",
            "clientType": "gfe",
            "version": "v.0.1"
        },
        "tracerFeature": true,
        "tracer": {
            "access_token": "bb9b4983d436567559f92bb300e1103a",
            "component_name": "Gfe_Client",
            "collector_host": "ls.dtrace.nvidia.com",
            "collector_port": 443
        }
    })
    .constant('GFECLIENT_BUILD_INFO', {
        "gfePackageVersion": "3.16.0.140",
        "branch": "rel_03_16",
        "branchType": "rel",
        "gfeclientVersion": "0.1.0",
        "gitHash": "4682b1f9ff",
        "buildType": "prod"
    });